#===================================================================
#
#   SEMAPH.MAK - Semaph Application Make file
#   (C) Copyright IBM Corporation 1992.
#
#===================================================================
!include ..\toolkit.inc

CC = wcc386 -d2 -D_Optlink=
LINK = wlink debug all
HEADERS = semaph.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
ALL_OBJS = sem_main.obj sem_user.obj sem_init.obj sem_pnt.obj &
           semaph.obj sem_help.obj sem_dlg.obj
ALL_IPF =  semaph.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: semaph.exe semaph.hlp .symbolic
    @%null

#-------------------------------------------------------------------
#
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#
#-------------------------------------------------------------------
semaph.res: semaph.rc $(HEADERS) semaph.dlg semaph.ico

semaph.hlp : $(ALL_IPF)

sem_main.obj: sem_main.c $(HEADERS)

sem_edit.obj: sem_edit.c $(HEADERS)

sem_user.obj: sem_user.c $(HEADERS)

semaph.obj: semaph.c $(HEADERS)

sem_help.obj: sem_help.c $(HEADERS)

sem_init.obj: sem_init.c $(HEADERS)

sem_pnt.obj: sem_pnt.c $(HEADERS)

sem_dlg.obj: sem_dlg.c $(HEADERS)

semaph.exe: $(ALL_OBJS) semaph.lnk semaph.res
    $(LINK) @semaph.lnk opt symfile
    rc -p -x semaph.res semaph.exe
    copy /b semaph.exe + semaph.sym
